import paho.mqtt.client as mqtt

if __name__ == '__main__':
    # Parameters
    host = "172.128.0.2"
    port = 1883
    
    # Message callback
    def on_message(client, userdata, msg):
      print("Topic: " + msg.topic + "\nPayload: " + str(msg.payload) + "\n")
    
    # Connection callback
    def on_connect(client, userdata, flags, rc):
      client.subscribe("cmtk/cmtkv1/port1/pd")  

    try:
      # Connect 
      client = mqtt.Client()
      client.on_connect = on_connect
      client.on_message = on_message
      client.connect(host, port, 3)

      # Loop
      client.loop_forever()

      # Disconnect
      client.disconnect()
    except:
        print("MQTT error.")
